Rem SelectObjects.vbs
Rem An InDesign VBScript
Rem
Rem This script selects all objects of a given type or types on the active spread.
Rem When you choose one of the imported graphic types, the script will select
Rem the frame containing the graphic (and not the graphic itself).
Rem
Rem This script also demonstrates a (fairly trivial) use of the Scripting Dictionary object.
Rem
Rem For more on InDesign/InCopy scripting see the documentation included in the Scripting SDK 
Rem available at http://www.adobe.com/devnet/indesign/sdk.html
Rem or visit the InDesign Scripting User to User forum at http://www.adobeforums.com
Rem
main
Function main()
	Set myInDesign = CreateObject("InDesign.Application.2024")
	Rem Set the user interaction level to allow the display of dialog boxes and alerts.
	myInDesign.ScriptPreferences.UserInteractionLevel = idUserInteractionLevels.idInteractWithAll
	If myInDesign.Documents.Count > 0 Then
	    If TypeName(myInDesign.ActiveWindow) = "LayoutWindow" Then
	        If myInDesign.ActiveWindow.ActiveSpread.PageItems.Count > 0 Then
	            myDisplayDialog myInDesign
	        End If
	    End If
	End If
End Function
Function myDisplayDialog(myInDesign)
    Set myDialog = myInDesign.Dialogs.Add
    myDialog.Name = "SelectObjects"
    With myDialog
        With .DialogColumns.Add
            With .BorderPanels.Add
                With .StaticTexts.Add
                    .StaticLabel = "Select:"
                End With
                With .DialogColumns.Add
                    Set myRectanglesCheckbox = .CheckboxControls.Add
                    myRectanglesCheckbox.StaticLabel = "&Rectangles"
                    myRectanglesCheckbox.CheckedState = True
                    Set myOvalsCheckbox = .CheckboxControls.Add
                    myOvalsCheckbox.StaticLabel = "&Ovals"
                    myOvalsCheckbox.CheckedState = True
                    Set myPolygonsCheckbox = .CheckboxControls.Add
                    myPolygonsCheckbox.StaticLabel = "&Polygons"
                    myPolygonsCheckbox.CheckedState = True
                    Set myGraphicLinesCheckbox = .CheckboxControls.Add
                    myGraphicLinesCheckbox.StaticLabel = "&Graphic Lines"
                    myGraphicLinesCheckbox.CheckedState = True
                    Set myTextFramesCheckbox = .CheckboxControls.Add
                    myTextFramesCheckbox.StaticLabel = "&Text Frames"
                    myTextFramesCheckbox.CheckedState = True
                    Set myGroupsCheckbox = .CheckboxControls.Add
                    myGroupsCheckbox.StaticLabel = "G&roups"
                    myGroupsCheckbox.CheckedState = True
                    Set myImagesCheckbox = .CheckboxControls.Add
                    myImagesCheckbox.StaticLabel = "&Images"
                    myImagesCheckbox.CheckedState = True
                    Set myPDFsCheckbox = .CheckboxControls.Add
                    myPDFsCheckbox.StaticLabel = "P&DFs"
                    myPDFsCheckbox.CheckedState = True
                    Set myEPSsCheckbox = .CheckboxControls.Add
                    myEPSsCheckbox.StaticLabel = "EP&Ss"
                    myEPSsCheckbox.CheckedState = True
                End With
            End With
        End With
    End With
    myResult = myDialog.Show
    If myResult = True Then
    Set myDictionary = CreateObject("Scripting.Dictionary")
        If myRectanglesCheckbox.CheckedState = True Then
            myDictionary.Add "Rectangle", "Rectangle"
        End If
        If myOvalsCheckbox.CheckedState = True Then
            myDictionary.Add "Oval", "Oval"
        End If
        If myPolygonsCheckbox.CheckedState = True Then
            myDictionary.Add "Polygon", "Polygon"
        End If
        If myGraphicLinesCheckbox.CheckedState = True Then
            myDictionary.Add "GraphicLine", "GraphicLine"
        End If
        If myTextFramesCheckbox.CheckedState = True Then
            myDictionary.Add "TextFrame", "TextFrame"
        End If
        If myGroupsCheckbox.CheckedState = True Then
            myDictionary.Add "Group", "Group"
        End If
        If myImagesCheckbox.CheckedState = True Then
            myDictionary.Add "Image", "Image"
        End If
        If myPDFsCheckbox.CheckedState = True Then
            myDictionary.Add "PDF", "PDF"
        End If
        If myEPSsCheckbox.CheckedState = True Then
            myDictionary.Add "EPS", "EPS"
        End If
        Rem Remove the dialog from memory.
        myDialog.Destroy
        mySelectObjects myInDesign, myDictionary
    Else
        Rem Remove the dialog from memory.
        myDialog.Destroy
    End If
End Function
Function mySelectObjects(myInDesign, myDictionary)
    ReDim myObjectsToSelect(0)
    Set mySpread = myInDesign.ActiveWindow.ActiveSpread
    For myCounter = 1 To mySpread.PageItems.Count
        Set myPageItem = mySpread.PageItems.Item(myCounter)
        If myDictionary.Exists(TypeName(myPageItem)) Then
            If IsEmpty(myObjectsToSelect(0)) Then
                Set myObjectsToSelect(0) = myPageItem
            Else
                ReDim Preserve myObjectsToSelect(UBound(myObjectsToSelect) + 1)
                Set myObjectsToSelect(UBound(myObjectsToSelect)) = myPageItem
            End If
        Else
            If myPageItem.Graphics.Count > 0 Then
                If myDictionary.Exists(TypeName(myPageItem.Graphics.Item(1))) Then
                    If IsEmpty(myObjectsToSelect(0)) Then
                        Set myObjectsToSelect(0) = myPageItem
                    Else
                        ReDim Preserve myObjectsToSelect(UBound(myObjectsToSelect) + 1)
                        Set myObjectsToSelect(UBound(	myObjectsToSelect)) = myPageItem
                    End If
                End If
            End If
        End If
    Next
    myInDesign.ActiveDocument.Select myObjectsToSelect, idSelectionOptions.idReplaceWith
End Function

'' SIG '' Begin signature block
'' SIG '' MIIpyAYJKoZIhvcNAQcCoIIpuTCCKbUCAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' XryInJH2IJfNMGL2mItsKlJvrO4m+M9lVBNof8IZ2SGg
'' SIG '' gg6WMIIGsDCCBJigAwIBAgIQCK1AsmDSnEyfXs2pvZOu
'' SIG '' 2TANBgkqhkiG9w0BAQwFADBiMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdpQ2Vy
'' SIG '' dCBUcnVzdGVkIFJvb3QgRzQwHhcNMjEwNDI5MDAwMDAw
'' SIG '' WhcNMzYwNDI4MjM1OTU5WjBpMQswCQYDVQQGEwJVUzEX
'' SIG '' MBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNVBAMT
'' SIG '' OERpZ2lDZXJ0IFRydXN0ZWQgRzQgQ29kZSBTaWduaW5n
'' SIG '' IFJTQTQwOTYgU0hBMzg0IDIwMjEgQ0ExMIICIjANBgkq
'' SIG '' hkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA1bQvQtAorXi3
'' SIG '' XdU5WRuxiEL1M4zrPYGXcMW7xIUmMJ+kjmjYXPXrNCQH
'' SIG '' 4UtP03hD9BfXHtr50tVnGlJPDqFX/IiZwZHMgQM+TXAk
'' SIG '' ZLON4gh9NH1MgFcSa0OamfLFOx/y78tHWhOmTLMBICXz
'' SIG '' ENOLsvsI8IrgnQnAZaf6mIBJNYc9URnokCF4RS6hnyzh
'' SIG '' GMIazMXuk0lwQjKP+8bqHPNlaJGiTUyCEUhSaN4QvRRX
'' SIG '' XegYE2XFf7JPhSxIpFaENdb5LpyqABXRN/4aBpTCfMjq
'' SIG '' GzLmysL0p6MDDnSlrzm2q2AS4+jWufcx4dyt5Big2MEj
'' SIG '' R0ezoQ9uo6ttmAaDG7dqZy3SvUQakhCBj7A7CdfHmzJa
'' SIG '' wv9qYFSLScGT7eG0XOBv6yb5jNWy+TgQ5urOkfW+0/tv
'' SIG '' k2E0XLyTRSiDNipmKF+wc86LJiUGsoPUXPYVGUztYuBe
'' SIG '' M/Lo6OwKp7ADK5GyNnm+960IHnWmZcy740hQ83eRGv7b
'' SIG '' UKJGyGFYmPV8AhY8gyitOYbs1LcNU9D4R+Z1MI3sMJN2
'' SIG '' FKZbS110YU0/EpF23r9Yy3IQKUHw1cVtJnZoEUETWJrc
'' SIG '' JisB9IlNWdt4z4FKPkBHX8mBUHOFECMhWWCKZFTBzCEa
'' SIG '' 6DgZfGYczXg4RTCZT/9jT0y7qg0IU0F8WD1Hs/q27Iwy
'' SIG '' CQLMbDwMVhECAwEAAaOCAVkwggFVMBIGA1UdEwEB/wQI
'' SIG '' MAYBAf8CAQAwHQYDVR0OBBYEFGg34Ou2O/hfEYb7/mF7
'' SIG '' CIhl9E5CMB8GA1UdIwQYMBaAFOzX44LScV1kTN8uZz/n
'' SIG '' upiuHA9PMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAK
'' SIG '' BggrBgEFBQcDAzB3BggrBgEFBQcBAQRrMGkwJAYIKwYB
'' SIG '' BQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBB
'' SIG '' BggrBgEFBQcwAoY1aHR0cDovL2NhY2VydHMuZGlnaWNl
'' SIG '' cnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcnQw
'' SIG '' QwYDVR0fBDwwOjA4oDagNIYyaHR0cDovL2NybDMuZGln
'' SIG '' aWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5j
'' SIG '' cmwwHAYDVR0gBBUwEzAHBgVngQwBAzAIBgZngQwBBAEw
'' SIG '' DQYJKoZIhvcNAQEMBQADggIBADojRD2NCHbuj7w6mdNW
'' SIG '' 4AIapfhINPMstuZ0ZveUcrEAyq9sMCcTEp6QRJ9L/Z6j
'' SIG '' fCbVN7w6XUhtldU/SfQnuxaBRVD9nL22heB2fjdxyyL3
'' SIG '' WqqQz/WTauPrINHVUHmImoqKwba9oUgYftzYgBoRGRjN
'' SIG '' YZmBVvbJ43bnxOQbX0P4PpT/djk9ntSZz0rdKOtfJqGV
'' SIG '' WEjVGv7XJz/9kNF2ht0csGBc8w2o7uCJob054ThO2m67
'' SIG '' Np375SFTWsPK6Wrxoj7bQ7gzyE84FJKZ9d3OVG3ZXQIU
'' SIG '' H0AzfAPilbLCIXVzUstG2MQ0HKKlS43Nb3Y3LIU/Gs4m
'' SIG '' 6Ri+kAewQ3+ViCCCcPDMyu/9KTVcH4k4Vfc3iosJocsL
'' SIG '' 6TEa/y4ZXDlx4b6cpwoG1iZnt5LmTl/eeqxJzy6kdJKt
'' SIG '' 2zyknIYf48FWGysj/4+16oh7cGvmoLr9Oj9FpsToFpFS
'' SIG '' i0HASIRLlk2rREDjjfAVKM7t8RhWByovEMQMCGQ8M4+u
'' SIG '' KIw8y4+ICw2/O/TOHnuO77Xry7fwdxPm5yg/rBKupS8i
'' SIG '' bEH5glwVZsxsDsrFhsP2JjMMB0ug0wcCampAMEhLNKhR
'' SIG '' ILutG4UI4lkNbcoFUCvqShyepf2gpx8GdOfy1lKQ/a+F
'' SIG '' SCH5Vzu0nAPthkX0tGFuv2jiJmCG6sivqf6UHedjGzqG
'' SIG '' VnhOMIIH3jCCBcagAwIBAgIQD99ExMbwCe2qSx8hp1o/
'' SIG '' EDANBgkqhkiG9w0BAQsFADBpMQswCQYDVQQGEwJVUzEX
'' SIG '' MBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNVBAMT
'' SIG '' OERpZ2lDZXJ0IFRydXN0ZWQgRzQgQ29kZSBTaWduaW5n
'' SIG '' IFJTQTQwOTYgU0hBMzg0IDIwMjEgQ0ExMB4XDTIzMTEw
'' SIG '' MzAwMDAwMFoXDTI1MTEwNDIzNTk1OVowgeYxEzARBgsr
'' SIG '' BgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIBAhMI
'' SIG '' RGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3JnYW5p
'' SIG '' emF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYDVQQG
'' SIG '' EwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNhbiBK
'' SIG '' b3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYDVQQL
'' SIG '' EyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29weSwg
'' SIG '' TXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCAiIwDQYJ
'' SIG '' KoZIhvcNAQEBBQADggIPADCCAgoCggIBAPCR5c/cgyg4
'' SIG '' MpJD46/+BWENPhE1RjN77VE2BWlIUdiO2nlWelKthEq9
'' SIG '' aK+1ofKIlDVc9mvxksuXBLESi7HBt3PCVBntNJkjBJd0
'' SIG '' EXeprmDK8HZrz8y/KSwEewbTMjneMRIRcJV2GMoAyUzK
'' SIG '' EyFJF7m6ByeoNBDDXMD4AQF5C2l3wfvRbREw+G+cyeya
'' SIG '' 564AHpFJ9sfqi9jAycnEZISxEf6N72GgGQr04cZt3JTb
'' SIG '' TktZGt6uWdZnseXDLGRHzFu4P4EqmVKvfMDliaKyWBzV
'' SIG '' lY+gmtE1vSxIK79WTySFrFY5j1vtbKyHybk6tv4TOmLt
'' SIG '' Lw4OP/ngVDiw/ZP+b7saGxPOEfuh5LOAr+llt+6V5NhT
'' SIG '' dkYPR6cbokawwX2DbGg7IeVuUPdf9bx/LznFV/8kPxCB
'' SIG '' J6qg0dqvCmQt/XbBXPJUvDoVJ9z+9hDlrAoLESqpHK8U
'' SIG '' 73UFGohBMJ/7itIyKngem7Ms98z6x0i63FJA8C06g+XE
'' SIG '' GJUmR28+c6ba+m/sc6xHI4zdL5a84UeRS9+u8UL8N4av
'' SIG '' fpSxHYTTxVjk1ZlwQ8dLARwEVWvTu4lRcEck3RPogx7o
'' SIG '' o8wUpSw9++m+Oi+K/z7RP/R67uCEtrkdM5N/xUoQR/t6
'' SIG '' 3P2ia9g8+LuYJ2BNBd1+qMcSoSlDfIFLFMeeqESbMv+j
'' SIG '' UsRQJn2lZvufAgMBAAGjggICMIIB/jAfBgNVHSMEGDAW
'' SIG '' gBRoN+Drtjv4XxGG+/5hewiIZfROQjAdBgNVHQ4EFgQU
'' SIG '' RPnrJ9yT26rMrd/Q4PfQSlgeaRcwPQYDVR0gBDYwNDAy
'' SIG '' BgVngQwBAzApMCcGCCsGAQUFBwIBFhtodHRwOi8vd3d3
'' SIG '' LmRpZ2ljZXJ0LmNvbS9DUFMwDgYDVR0PAQH/BAQDAgeA
'' SIG '' MBMGA1UdJQQMMAoGCCsGAQUFBwMDMIG1BgNVHR8Ega0w
'' SIG '' gaowU6BRoE+GTWh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNv
'' SIG '' bS9EaWdpQ2VydFRydXN0ZWRHNENvZGVTaWduaW5nUlNB
'' SIG '' NDA5NlNIQTM4NDIwMjFDQTEuY3JsMFOgUaBPhk1odHRw
'' SIG '' Oi8vY3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVz
'' SIG '' dGVkRzRDb2RlU2lnbmluZ1JTQTQwOTZTSEEzODQyMDIx
'' SIG '' Q0ExLmNybDCBlAYIKwYBBQUHAQEEgYcwgYQwJAYIKwYB
'' SIG '' BQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBc
'' SIG '' BggrBgEFBQcwAoZQaHR0cDovL2NhY2VydHMuZGlnaWNl
'' SIG '' cnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZEc0Q29kZVNpZ25p
'' SIG '' bmdSU0E0MDk2U0hBMzg0MjAyMUNBMS5jcnQwCQYDVR0T
'' SIG '' BAIwADANBgkqhkiG9w0BAQsFAAOCAgEAPIZ9C4IuKg85
'' SIG '' 0H8M66OLMVllIpANmEjijIG/D65qP6jfma+2WFps2bb+
'' SIG '' vKKIEtG9TFtCAlSrA1OV6Ru78paq0gqw/q3QAN0OleFR
'' SIG '' F1NvT/TLO0ulhjXTETB1BwSKZaJH001DH0+60TmbGfVh
'' SIG '' mwLrEj2Zfl4COFwivZ/2tRoknZl5tmiu4hpjDbOapWd9
'' SIG '' 5cqliSoMeu2i588557eikdiDk6bXBa5MxHjyXvbvaIWN
'' SIG '' Zjsymn0L0sYkF3BToDN0h0XiTTZjZPHdSV2GjX6C/+Nj
'' SIG '' HSZGRtBaIxdAL1mKEWJV9qkEKELPb098rO+zGdn1E5IH
'' SIG '' pS1zSRIYngwZEjZfyoCkg1F+EW4QPs2+ff2CsW5i3IEd
'' SIG '' 7vL19w9oyce3S4wejvnlTKt+EQWn3gSPxrbkp3BxdWRN
'' SIG '' 25MKo5bS5bJ21BiwqcIJHcTxWNgaQPh4sZboi9IimCSn
'' SIG '' UenPQhqdeOuz0NnmepMEYd7L/kqnAeUZ8bW1UbITAWQ/
'' SIG '' UT3phjCfRQNpEh4OBoUcH8hOOHZ0Lh86mxv9lDP3i7c/
'' SIG '' bQzZnrJr2dS34JXolwREbTX9Yu5JB5X3YP539/M1Ms5O
'' SIG '' FZou/MHQBrWMsVBsEXDTWqwbMTYw/zvIiHXcGUnpzInw
'' SIG '' 1jQXlLrmwVHW4ug+A4LFO7bWC4mnZoDNWp0xnlGmbP6I
'' SIG '' ccJmW5C7RJMxghqKMIIahgIBATB9MGkxCzAJBgNVBAYT
'' SIG '' AlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjFBMD8G
'' SIG '' A1UEAxM4RGlnaUNlcnQgVHJ1c3RlZCBHNCBDb2RlIFNp
'' SIG '' Z25pbmcgUlNBNDA5NiBTSEEzODQgMjAyMSBDQTECEA/f
'' SIG '' RMTG8AntqksfIadaPxAwDQYJYIZIAWUDBAIBBQCggZww
'' SIG '' GQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYB
'' SIG '' BAGCNwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcN
'' SIG '' AQkEMSIEIB6jcmTMWns3RvFE84vmC6kh7Dn6dNKyjh6A
'' SIG '' nD9wACa/MDAGCisGAQQBgjcCAQwxIjAgoB6AHABBAGQA
'' SIG '' bwBiAGUAIABJAG4ARABlAHMAaQBnAG4wDQYJKoZIhvcN
'' SIG '' AQEBBQAEggIA2baCBp/Yx824pOBFuS+XxoHOHGuTvCXN
'' SIG '' Uc4kGeeiXONUlaOjR0kUHjJiAwEqD4/dMfHRXm/FNilH
'' SIG '' XJTTEJUDQXe/7u10FvCRlnyJgIBH3eF7KLEPI+5HQMLr
'' SIG '' VLpcaSaK9FT5945LsolLnPCRos2rEfM3m41vOmsR80ww
'' SIG '' cvsH2yb9YjxOyP8g9Ep4WWBW+e4IrNgchyTFgbT6Z7Wx
'' SIG '' yAyh9zYIe7vTtoUjS+z1c2vbhQnsIjwEZT+5AuDTxqDa
'' SIG '' PpcQjrZkNPDic5RsCELGfXqo9oK8y1ft9mhJmmsV8AN5
'' SIG '' TD/2SZAxm4Ti+EWGHHIcKS+JaPnJmaUqhcJSJyo9qSyt
'' SIG '' KQGrRMwVumxzi7xd4ek25MOGFq06X6BGg0FZ24182bkW
'' SIG '' lQxkTnbHAGg690cPO+7pkrCqPMb4ii7iJ7iPhJ+RqZuI
'' SIG '' kDs0Hik6Xhogk0GsmnfQnEW8je8JFMprjN0eeoLdHwoK
'' SIG '' XDBM9+5WgsxFe/BKn6m7wTIPQiyVdwh6lQmDqCp/D/s5
'' SIG '' 9xdsVRUwwvG71aJSazn5tgXO4f7H6wZxEp5jPEK2GxS7
'' SIG '' iH7qU1Ni5TByV6tPRohieaPLt62fBNGgaJ4w2NJYkD3m
'' SIG '' m/qR/Okx7ZBnyYDURgdnowKwCtyteRh0aUr/PuAO5376
'' SIG '' rg65hOsu6itM42j9tfhIcldpjkPvYQKzxVWhghc/MIIX
'' SIG '' OwYKKwYBBAGCNwMDATGCFyswghcnBgkqhkiG9w0BBwKg
'' SIG '' ghcYMIIXFAIBAzEPMA0GCWCGSAFlAwQCAQUAMHcGCyqG
'' SIG '' SIb3DQEJEAEEoGgEZjBkAgEBBglghkgBhv1sBwEwMTAN
'' SIG '' BglghkgBZQMEAgEFAAQg6RWfOBmYtbKPBbStBwZFwEKT
'' SIG '' vsWT0be6s45tf/BGWHECEEQYO82zXw7AVCUXLtGkhckY
'' SIG '' DzIwMjQwMTI2MjM1NDQwWqCCEwkwggbCMIIEqqADAgEC
'' SIG '' AhAFRK/zlJ0IOaa/2z9f5WEWMA0GCSqGSIb3DQEBCwUA
'' SIG '' MGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2Vy
'' SIG '' dCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3Rl
'' SIG '' ZCBHNCBSU0E0MDk2IFNIQTI1NiBUaW1lU3RhbXBpbmcg
'' SIG '' Q0EwHhcNMjMwNzE0MDAwMDAwWhcNMzQxMDEzMjM1OTU5
'' SIG '' WjBIMQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNl
'' SIG '' cnQsIEluYy4xIDAeBgNVBAMTF0RpZ2lDZXJ0IFRpbWVz
'' SIG '' dGFtcCAyMDIzMIICIjANBgkqhkiG9w0BAQEFAAOCAg8A
'' SIG '' MIICCgKCAgEAo1NFhx2DjlusPlSzI+DPn9fl0uddoQ4J
'' SIG '' 3C9Io5d6OyqcZ9xiFVjBqZMRp82qsmrdECmKHmJjadNY
'' SIG '' nDVxvzqX65RQjxwg6seaOy+WZuNp52n+W8PWKyAcwZeU
'' SIG '' tKVQgfLPywemMGjKg0La/H8JJJSkghraarrYO8pd3hkY
'' SIG '' hftF6g1hbJ3+cV7EBpo88MUueQ8bZlLjyNY+X9pD04T1
'' SIG '' 0Mf2SC1eRXWWdf7dEKEbg8G45lKVtUfXeCk5a+B4WZfj
'' SIG '' RCtK1ZXO7wgX6oJkTf8j48qG7rSkIWRw69XloNpjsy7p
'' SIG '' Be6q9iT1HbybHLK3X9/w7nZ9MZllR1WdSiQvrCuXvp/k
'' SIG '' /XtzPjLuUjT71Lvr1KAsNJvj3m5kGQc3AZEPHLVRzapM
'' SIG '' ZoOIaGK7vEEbeBlt5NkP4FhB+9ixLOFRr7StFQYU6mII
'' SIG '' E9NpHnxkTZ0P387RXoyqq1AVybPKvNfEO2hEo6U7Qv1z
'' SIG '' fe7dCv95NBB+plwKWEwAPoVpdceDZNZ1zY8SdlalJPrX
'' SIG '' xGshuugfNJgvOuprAbD3+yqG7HtSOKmYCaFxsmxxrz64
'' SIG '' b5bV4RAT/mFHCoz+8LbH1cfebCTwv0KCyqBxPZySkwS0
'' SIG '' aXAnDU+3tTbRyV8IpHCj7ArxES5k4MsiK8rxKBMhSVF+
'' SIG '' BmbTO77665E42FEHypS34lCh8zrTioPLQHsCAwEAAaOC
'' SIG '' AYswggGHMA4GA1UdDwEB/wQEAwIHgDAMBgNVHRMBAf8E
'' SIG '' AjAAMBYGA1UdJQEB/wQMMAoGCCsGAQUFBwMIMCAGA1Ud
'' SIG '' IAQZMBcwCAYGZ4EMAQQCMAsGCWCGSAGG/WwHATAfBgNV
'' SIG '' HSMEGDAWgBS6FtltTYUvcyl2mi91jGogj57IbzAdBgNV
'' SIG '' HQ4EFgQUpbbvE+fvzdBkodVWqWUxo97V40kwWgYDVR0f
'' SIG '' BFMwUTBPoE2gS4ZJaHR0cDovL2NybDMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0VHJ1c3RlZEc0UlNBNDA5NlNIQTI1
'' SIG '' NlRpbWVTdGFtcGluZ0NBLmNybDCBkAYIKwYBBQUHAQEE
'' SIG '' gYMwgYAwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRp
'' SIG '' Z2ljZXJ0LmNvbTBYBggrBgEFBQcwAoZMaHR0cDovL2Nh
'' SIG '' Y2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3Rl
'' SIG '' ZEc0UlNBNDA5NlNIQTI1NlRpbWVTdGFtcGluZ0NBLmNy
'' SIG '' dDANBgkqhkiG9w0BAQsFAAOCAgEAgRrW3qCptZgXvHCN
'' SIG '' T4o8aJzYJf/LLOTN6l0ikuyMIgKpuM+AqNnn48XtJoKK
'' SIG '' cS8Y3U623mzX4WCcK+3tPUiOuGu6fF29wmE3aEl3o+uQ
'' SIG '' qhLXJ4Xzjh6S2sJAOJ9dyKAuJXglnSoFeoQpmLZXeY/b
'' SIG '' JlYrsPOnvTcM2Jh2T1a5UsK2nTipgedtQVyMadG5K8TG
'' SIG '' e8+c+njikxp2oml101DkRBK+IA2eqUTQ+OVJdwhaIcW0
'' SIG '' z5iVGlS6ubzBaRm6zxbygzc0brBBJt3eWpdPM43UjXd9
'' SIG '' dUWhpVgmagNF3tlQtVCMr1a9TMXhRsUo063nQwBw3syY
'' SIG '' nhmJA+rUkTfvTVLzyWAhxFZH7doRS4wyw4jmWOK22z75
'' SIG '' X7BC1o/jF5HRqsBV44a/rCcsQdCaM0qoNtS5cpZ+l3k4
'' SIG '' SF/Kwtw9Mt911jZnWon49qfH5U81PAC9vpwqbHkB3NpE
'' SIG '' 5jreODsHXjlY9HxzMVWggBHLFAx+rrz+pOt5Zapo1iLK
'' SIG '' O+uagjVXKBbLafIymrLS2Dq4sUaGa7oX/cR3bBVsrquv
'' SIG '' czroSUa31X/MtjjA2Owc9bahuEMs305MfR5ocMB3CtQC
'' SIG '' 4Fxguyj/OOVSWtasFyIjTvTs0xf7UGv/B3cfcZdEQcm4
'' SIG '' RtNsMnxYL2dHZeUbc7aZ+WssBkbvQR7w8F/g29mtkIBE
'' SIG '' r4AQQYowggauMIIElqADAgECAhAHNje3JFR82Ees/Shm
'' SIG '' Kl5bMA0GCSqGSIb3DQEBCwUAMGIxCzAJBgNVBAYTAlVT
'' SIG '' MRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsT
'' SIG '' EHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERpZ2lD
'' SIG '' ZXJ0IFRydXN0ZWQgUm9vdCBHNDAeFw0yMjAzMjMwMDAw
'' SIG '' MDBaFw0zNzAzMjIyMzU5NTlaMGMxCzAJBgNVBAYTAlVT
'' SIG '' MRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7MDkGA1UE
'' SIG '' AxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2IFNI
'' SIG '' QTI1NiBUaW1lU3RhbXBpbmcgQ0EwggIiMA0GCSqGSIb3
'' SIG '' DQEBAQUAA4ICDwAwggIKAoICAQDGhjUGSbPBPXJJUVXH
'' SIG '' JQPE8pE3qZdRodbSg9GeTKJtoLDMg/la9hGhRBVCX6SI
'' SIG '' 82j6ffOciQt/nR+eDzMfUBMLJnOWbfhXqAJ9/UO0hNoR
'' SIG '' 8XOxs+4rgISKIhjf69o9xBd/qxkrPkLcZ47qUT3w1lbU
'' SIG '' 5ygt69OxtXXnHwZljZQp09nsad/ZkIdGAHvbREGJ3Hxq
'' SIG '' V3rwN3mfXazL6IRktFLydkf3YYMZ3V+0VAshaG43IbtA
'' SIG '' rF+y3kp9zvU5EmfvDqVjbOSmxR3NNg1c1eYbqMFkdECn
'' SIG '' wHLFuk4fsbVYTXn+149zk6wsOeKlSNbwsDETqVcplicu
'' SIG '' 9Yemj052FVUmcJgmf6AaRyBD40NjgHt1biclkJg6OBGz
'' SIG '' 9vae5jtb7IHeIhTZgirHkr+g3uM+onP65x9abJTyUpUR
'' SIG '' K1h0QCirc0PO30qhHGs4xSnzyqqWc0Jon7ZGs506o9UD
'' SIG '' 4L/wojzKQtwYSH8UNM/STKvvmz3+DrhkKvp1KCRB7UK/
'' SIG '' BZxmSVJQ9FHzNklNiyDSLFc1eSuo80VgvCONWPfcYd6T
'' SIG '' /jnA+bIwpUzX6ZhKWD7TA4j+s4/TXkt2ElGTyYwMO1uK
'' SIG '' IqjBJgj5FBASA31fI7tk42PgpuE+9sJ0sj8eCXbsq11G
'' SIG '' deJgo1gJASgADoRU7s7pXcheMBK9Rp6103a50g5rmQzS
'' SIG '' M7TNsQIDAQABo4IBXTCCAVkwEgYDVR0TAQH/BAgwBgEB
'' SIG '' /wIBADAdBgNVHQ4EFgQUuhbZbU2FL3MpdpovdYxqII+e
'' SIG '' yG8wHwYDVR0jBBgwFoAU7NfjgtJxXWRM3y5nP+e6mK4c
'' SIG '' D08wDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQMMAoGCCsG
'' SIG '' AQUFBwMIMHcGCCsGAQUFBwEBBGswaTAkBggrBgEFBQcw
'' SIG '' AYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEEGCCsG
'' SIG '' AQUFBzAChjVodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5j
'' SIG '' b20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNydDBDBgNV
'' SIG '' HR8EPDA6MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2Vy
'' SIG '' dC5jb20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNybDAg
'' SIG '' BgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEw
'' SIG '' DQYJKoZIhvcNAQELBQADggIBAH1ZjsCTtm+YqUQiAX5m
'' SIG '' 1tghQuGwGC4QTRPPMFPOvxj7x1Bd4ksp+3CKDaopafxp
'' SIG '' wc8dB+k+YMjYC+VcW9dth/qEICU0MWfNthKWb8RQTGId
'' SIG '' DAiCqBa9qVbPFXONASIlzpVpP0d3+3J0FNf/q0+KLHqr
'' SIG '' hc1DX+1gtqpPkWaeLJ7giqzl/Yy8ZCaHbJK9nXzQcAp8
'' SIG '' 76i8dU+6WvepELJd6f8oVInw1YpxdmXazPByoyP6wCeC
'' SIG '' RK6ZJxurJB4mwbfeKuv2nrF5mYGjVoarCkXJ38SNoOeY
'' SIG '' +/umnXKvxMfBwWpx2cYTgAnEtp/Nh4cku0+jSbl3ZpHx
'' SIG '' cpzpSwJSpzd+k1OsOx0ISQ+UzTl63f8lY5knLD0/a6fx
'' SIG '' ZsNBzU+2QJshIUDQtxMkzdwdeDrknq3lNHGS1yZr5Dhz
'' SIG '' q6YBT70/O3itTK37xJV77QpfMzmHQXh6OOmc4d0j/R0o
'' SIG '' 08f56PGYX/sr2H7yRp11LB4nLCbbbxV7HhmLNriT1Oby
'' SIG '' F5lZynDwN7+YAN8gFk8n+2BnFqFmut1VwDophrCYoCvt
'' SIG '' lUG3OtUVmDG0YgkPCr2B2RP+v6TR81fZvAT6gt4y3wSJ
'' SIG '' 8ADNXcL50CN/AAvkdgIm2fBldkKmKYcJRyvmfxqkhQ/8
'' SIG '' mJb2VVQrH4D6wPIOK+XW+6kvRBVK5xMOHds3OBqhK/bt
'' SIG '' 1nz8MIIFjTCCBHWgAwIBAgIQDpsYjvnQLefv21DiCEAY
'' SIG '' WjANBgkqhkiG9w0BAQwFADBlMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2Vy
'' SIG '' dCBBc3N1cmVkIElEIFJvb3QgQ0EwHhcNMjIwODAxMDAw
'' SIG '' MDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJV
'' SIG '' UzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQL
'' SIG '' ExB3d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdp
'' SIG '' Q2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
'' SIG '' DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAi
'' SIG '' MGkz7MKnJS7JIT3yithZwuEppz1Yq3aaza57G4QNxDAf
'' SIG '' 8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4VpX6+
'' SIG '' n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7
'' SIG '' bXHiLQwb7iDVySAdYyktzuxeTsiT+CFhmzTrBcZe7Fsa
'' SIG '' vOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3T6cw2Vbu
'' SIG '' yntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHE
'' SIG '' tWoYOAMQjdjUN6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6R
'' SIG '' AXwhTNS8rhsDdV14Ztk6MUSaM0C/CNdaSaTC5qmgZ92k
'' SIG '' J7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI
'' SIG '' 8OCiEhtmmnTK3kse5w5jrubU75KSOp493ADkRSWJtppE
'' SIG '' GSt+wJS00mFt6zPZxd9LBADMfRyVw4/3IbKyEbe7f/LV
'' SIG '' jHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QY
'' SIG '' uKZ3AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+N
'' SIG '' P8m800ERElvlEFDrMcXKchYiCd98THU/Y+whX8QgUWtv
'' SIG '' sauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
'' SIG '' sh3lGwIDAQABo4IBOjCCATYwDwYDVR0TAQH/BAUwAwEB
'' SIG '' /zAdBgNVHQ4EFgQU7NfjgtJxXWRM3y5nP+e6mK4cD08w
'' SIG '' HwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8w
'' SIG '' DgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAk
'' SIG '' BggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQu
'' SIG '' Y29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2FjZXJ0cy5k
'' SIG '' aWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290
'' SIG '' Q0EuY3J0MEUGA1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9j
'' SIG '' cmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJ
'' SIG '' RFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0G
'' SIG '' CSqGSIb3DQEBDAUAA4IBAQBwoL9DXFXnOF+go3QbPbYW
'' SIG '' 1/e/Vwe9mqyhhyzshV6pGrsi+IcaaVQi7aSId229GhT0
'' SIG '' E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n0
'' SIG '' 96wwepqLsl7Uz9FDRJtDIeuWcqFItJnLnU+nBgMTdydE
'' SIG '' 1Od/6Fmo8L8vC6bp8jQ87PcDx4eo0kxAGTVGamlUsLih
'' SIG '' Vo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsg
'' SIG '' jTVgHAIDyyCwrFigDkBjxZgiwbJZ9VVrzyerbHbObyMt
'' SIG '' 9H5xaiNrIv8SuFQtJ37YOtnwtoeW/VvRXKwYw02fc7cB
'' SIG '' qZ9Xql4o4rmUMYIDdjCCA3ICAQEwdzBjMQswCQYDVQQG
'' SIG '' EwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5
'' SIG '' BgNVBAMTMkRpZ2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5
'' SIG '' NiBTSEEyNTYgVGltZVN0YW1waW5nIENBAhAFRK/zlJ0I
'' SIG '' Oaa/2z9f5WEWMA0GCWCGSAFlAwQCAQUAoIHRMBoGCSqG
'' SIG '' SIb3DQEJAzENBgsqhkiG9w0BCRABBDAcBgkqhkiG9w0B
'' SIG '' CQUxDxcNMjQwMTI2MjM1NDQwWjArBgsqhkiG9w0BCRAC
'' SIG '' DDEcMBowGDAWBBRm8CsywsLJD4JdzqqKycZPGZzPQDAv
'' SIG '' BgkqhkiG9w0BCQQxIgQgtxsSQWhgmAgxN1PYdoCfXl2s
'' SIG '' 0XPfaoafF6IRKAHGAqYwNwYLKoZIhvcNAQkQAi8xKDAm
'' SIG '' MCQwIgQg0vbkbe10IszR1EBXaEE2b4KK2lWarjMWr00a
'' SIG '' mtQMeCgwDQYJKoZIhvcNAQEBBQAEggIAljUSGAG3QH/I
'' SIG '' a0TlFXf5omdDr2ifVwTJZ3Hc925yrkD8kGq5Dn9eAGS2
'' SIG '' A+64EyURnhH1i5pLSrx6t6YTcSP64LkhfZrhJgJwlRil
'' SIG '' xNdbdqoqjqQ3Po1t230eM4vOYbqUHwBbbGazTEy79fsU
'' SIG '' Fd8RkfBjxA1oTvg/9Oso5assn77BjOqccS0wYb7TCXDZ
'' SIG '' JXWZ4I2y4GbC7sdmExxQX3n5X0lJVfPe17EaQKGfPxnj
'' SIG '' YC//irgIP1gsREMZbbiECpst3XedWSyde2Vr9X1JAqxZ
'' SIG '' CrPAqIh1pK0qh7OEckhoEcvLsVVaUBD2NICBVrsdkfW3
'' SIG '' rLr+3Arw7S5ifzruXz0kgpCGqM57xnZK1zoMihzTOtFs
'' SIG '' 0hg6ttBczVgPyGKcThKKypQfR8tn3nAOjFEk4l/VWKJY
'' SIG '' P6rLNStR6VjwqKUU5XzV9bFRypXgBUowsqS0xaDWJxHY
'' SIG '' s/ovGxQcyVQRlO6n/uTKFPsmVd5pCrpaHCP9S0H+hHOQ
'' SIG '' uyDGfVJVM81dqVcpNnfd0H3rJ1Rw1rgCQCX0lF+LYbZ/
'' SIG '' 2Jve2ltTLOvZIi9HxWKvv9wPHz+DItjmt7+jEfkhEF0Y
'' SIG '' zO0OeuMZd/TS0U3WXMxP1OAmB+K2+0j48A/U1y2HC2aL
'' SIG '' q2ZgVX1RfO104nTOk9E291MdjsPwlgMPyigveQ0L5CqT
'' SIG '' NEN/r2CjBio=
'' SIG '' End signature block
